-- A modular library for displaying readonly messages, particularly for use in libraries.
libarchive = {
    variants = {
        note = {},
        scroll = {},
        book = {},
        bookshelf = {}
    }
}
local iteration = not not minetest.get_modpath("itbase")
local sprite3d = not not minetest.get_modpath("libsprite3d")
local register_node = minetest.register_node
if iteration then register_node = itbase.register_node end

dofile(minetest.get_modpath(minetest.get_current_modname()).."/fonts.lua")

minetest.register_node("libarchive:_ignore", {
    drawtype = "airlike",
    paramtype = "light",
    sunlight_propagates = true,
    buildable = false,
    walkable = false,
    pointable = false,
    can_break = function() return false end,
    groups = {not_in_creative_inventory = 1}
})

local current_pos = {}
register_node("libarchive:note", {
    _place_time = 0,
    _hand_placeable = true,
    _drop_single_as_node = true,
    groups = {
        hand_breakable = 20,
        sigil_breakable = 20,
        gravity_affected = 1,
        dig_immediate = 1,
        oddly_breakable_by_hand = 3
    },
    drawtype = sprite3d and "mesh" or "signlike",
    mesh = "item3d_floor.obj",
    paramtype = "light",
    paramtype2 = "facedir",
    tiles = {"libarchive_note.png"},
    use_texture_alpha = "clip",
    sunlight_propagates = true,
    walkable = false,
    node_box = {
        type = "fixed",
        fixed = {-6/16, -0.5, -7/16, 6/16, -7/16, 7/16}
    },
    selection_box = {
        type = "fixed",
        fixed = {-6/16, -0.5, -7/16, 6/16, -7/16, 7/16}
    },
    on_rightclick = function(pos, node, p, s)
        if not p then return end
        if p:get_player_control()[iteration and "sneak" or "aux1"] then
            if iteration or not minetest.is_protected(pos, p:get_player_name()) then
                current_pos[p:get_player_name()] = pos
                minetest.show_formspec(p:get_player_name(), "libarchive:noteedit", [[
                    formspec_version[7]
                    size[16,16]
                    bgcolor[#0000;;]
                    image[0,0;16,16;libarchive_note.png]
                    textarea[4.5,3.5;7,9;msg;;]]..minetest.get_meta(pos):get_string("libarchive_msg")..[[]
                    button_exit[4,14.5;8,1;confirm;Confirm]
                    ]])
            return end
        end
        local n = s:get_name()
        if n == "it:pencil" or n == "it:pen" or (iteration) then
            
        end
        local d = minetest.add_entity(pos, "libarchive:notedisplay", minetest.serialize{node = node, anchor = pos}):get_luaentity()
        minetest.swap_node(pos, {name="libarchive:_ignore"})
    end,
    on_place = function(s, p, pointed)
        if not p then return s end
        local msg = s:get_meta():get_string("libarchive_msg")
        local p2 = minetest.dir_to_facedir(vector.subtract(pointed.above or pointed.under, p:get_pos()))
        local stack, pos = minetest.item_place(s, p, pointed, p2)
        if pos then
            local m = minetest.get_meta(pos)
            m:set_string("libarchive_placer", p:get_player_name())
            m:set_string("libarchive_msg", msg)
            if iteration then itbase.check_falling(pos) end
        end
        return stack
    end,
    preserve_metadata = function(pos, node, m, drops)
        if drops[1] then drops[1]:get_meta():set_string("libarchive_msg", m.libarchive_msg) end
    end
})
if iteration then minetest.register_alias("it:note", "libarchive:note") end

minetest.register_entity("libarchive:notedisplay", {
    _anchor = vector.new(0,0,0),
    _active = false,
    _node = {name="air"},
    initial_properties = {
        visual = "mesh",
        mesh = "item3d_textlayer.obj",
        textures = {"grass.png", "libarchive_note.png"},
        selectionbox = {
            -0.25,-0.25,-0.25,
             0.25, 0.25, 0.25
        },
        visual_size = {x = 10, y = 10, z = 10},
        damage_texture_modifier = ""
    },
    _invoke = function(e)
        local i = 0
        local function frame()
            e.object:set_rotation(vector.add(e.object:get_rotation(), vector.new(5 *(8-i) /2, 0, 0):apply(math.rad)))
            e.object:set_pos(vector.add(e.object:get_pos(), vector.new(0, 1/16 *(8-i) /2, 0)))
            e.object:set_properties{
                visual_size = vector.add(e.object:get_properties().visual_size, vector.new(1 *(8-i) /2, 1 *(8-i) /2, 1 *(8-i) /2))
            }
            i = i + 1
            if i < 10 then minetest.after(0.02, frame) else e._active = true end
        end
        minetest.after(0.02, frame)
    end,
    _dismiss = function(e)
        e._active = false
        e.object:set_yaw(minetest.dir_to_yaw(minetest.facedir_to_dir(e._node.param2)))
        local i = 0
        local function frame()
            e.object:set_rotation(vector.add(e.object:get_rotation(), vector.new(-2 *(i) /2, 0, 0):apply(math.rad)))
            e.object:set_pos(vector.add(e.object:get_pos(), vector.new(0, -1/16 *(i) /2, 0)))
            e.object:set_properties{
                visual_size = vector.add(e.object:get_properties().visual_size, vector.new(-1 *(i) /2, -1 *(i) /2, -1 *(i) /2))
            }
            i = i + 1
            if i < 10 then
                minetest.after(0.02, frame)
            else
                e.object:remove()
                minetest.swap_node(e._anchor, e._node)
            end
        end
        minetest.after(0.02, frame)
    end,
    on_activate = function(e, data)
        data = minetest.deserialize(data)
        if not data then
            e.object:remove()
            return
        end
        e.object:set_armor_groups{immortal=1}
        e._anchor = data.anchor
        e._node = data.node
        local dir = minetest.facedir_to_dir(data.node.param2)
        e.object:set_yaw(minetest.dir_to_yaw(dir))
        e.object:set_pos(vector.add(e.object:get_pos(), vector.new(0, -15/32, 0)))
        
        e.object:set_properties{
            textures = {libarchive.rasterize(minetest.get_meta(e._anchor):get_string("libarchive_msg"), 512*2, 640*2, 144*2, 128*2), "libarchive_note.png"}
        }
        
        e:_invoke()
    end,
    on_step = function(e)
        if not e._active then return end
        local i = 0
        local cd = 999
        local cp = nil
        for _, obj in pairs(minetest.get_objects_inside_radius(e._anchor, 4)) do
            if minetest.is_player(obj) then
                i = i + 1
                local d = vector.length(vector.subtract(obj:get_pos(), e._anchor))
                if d < cd then
                    cd = d
                    cp = obj
                end
            end
        end
        if i == 0 then
            e:_dismiss()
        else
            local rot = e.object:get_rotation()
            rot.y = minetest.dir_to_yaw(vector.direction(e._anchor, cp:get_pos())) - math.rad(180)
            e.object:set_rotation(rot)
        end
    end,
    on_punch = function(e)
        if not e._active then return end
        e:_dismiss()
    end
})


register_node("libarchive:scroll", {
    
})
if iteration then minetest.register_alias("it:scroll", "libarchive:note") end

local bookedit_state = {}
local function show_bookedit_formspec(p)
    local m = bookedit_state[p:get_player_name()]
    local meta = minetest.get_meta(m.pos)
    minetest.show_formspec(p:get_player_name(), "libarchive:bookedit", [[
        formspec_version[7]
        size[16,16]
        bgcolor[#0000;;]
        style_type[model;noclip=true]
        style[lbl;bgcolor=#0000;border=false]
        style[lbl:hovered;bgcolor=#0000;border=false]
        style[lbl:pressed;bgcolor=#0000;border=false]
        style[lbl:focused;bgcolor=#0000;border=false]
        model[0,0;16,16;bg;libarchive_book.b3d;libarchive_book.png,blank.png,blank.png,blank.png,blank.png;-50,0;false;false;37,37;]
        button[4,1;1,1;fprev;<<]
        button[5,1;1,1;prev;<]
        button[6,1;4,1;lbl;Page ]]..m.page.." / "..#m.pages..[[]
        button[10,1;1,1;next;>]
        button[11,1;1,1;nextf;>>]
        textarea[5,6;6,5;msg]]..m.page..";;"..m.pages[m.page]..[[]
        button_exit[4,14.5;8,1;confirm;Confirm]
    ]])
end

register_node("libarchive:book", {
    _place_time = 0,
    _hand_placeable = true,
    _gravity_affected = "resting",
    _drop_single_as_node = true,
    groups = {
        hand_breakable = 20,
        sigil_breakable = 20,
        gravity_affected = 1,
        dig_immediate = 1,
        oddly_breakable_by_hand = 3
    },
    drawtype = "mesh",
    mesh = "libarchive_book.obj",
    paramtype = "light",
    paramtype2 = "facedir",
    tiles = {"libarchive_book.png"},
    use_texture_alpha = "clip",
    sunlight_propagates = true,
    node_box = {
        type = "fixed",
        fixed = {-6/16, -0.5, -7/16, 6/16, -2/16, 7/16}
    },
    selection_box = {
        type = "fixed",
        fixed = {-6/16, -0.5, -7/16, 6/16, -2/16, 7/16}
    },
    on_rightclick = function(pos, node, p, s)
        if not p then return end
        local m = minetest.get_meta(pos)
        if p:get_player_control()[iteration and "sneak" or "aux1"] then
            if iteration or not minetest.is_protected(pos, p:get_player_name()) then
                bookedit_state[p:get_player_name()] = {
                    pos = pos,
                    page = 1,
                    pages = m:contains("libarchive_pages") and minetest.deserialize(m:get_string("libarchive_pages")) or {""}
                }
                show_bookedit_formspec(p)
            return end
        end
        local d = minetest.add_entity(pos, "libarchive:bookdisplay", minetest.serialize{
            node = node,
            anchor = pos,
            pages = m:contains("libarchive_pages") and minetest.deserialize(m:get_string("libarchive_pages")) or {""}
        }):get_luaentity()
        minetest.swap_node(pos, {name="libarchive:_ignore"})
    end,
    on_place = function(s, p, pointed)
        if not p then return s end
        local msg = s:get_meta():get_string("libarchive_pages")
        local p2 = minetest.dir_to_facedir(vector.subtract(pointed.above, p:get_pos()))
        local stack, pos = minetest.item_place(s, p, pointed, p2)
        if pos then
            local m = minetest.get_meta(pos)
            m:set_string("libarchive_placer", p:get_player_name())
            m:set_string("libarchive_pages", msg)
            if iteration then itbase.check_falling(pos) end
        end
        return stack
    end,
    preserve_metadata = function(pos, node, m, drops)
        if drops[1] then drops[1]:get_meta():set_string("libarchive_pages", m.libarchive_pages) end
    end
})
if iteration then minetest.register_alias("it:book", "libarchive:book") end

minetest.register_entity("libarchive:bookdisplay", {
    _node = {name="air"},
    _anchor = vector.new(0,0,0),
    _active = false,
    _pages = {""},
    _page = 1,
    initial_properties = {
        visual = "mesh",
        mesh = "libarchive_book.b3d",
        textures = {"libarchive_book.png", "blank.png", "blank.png", "blank.png", "blank.png"},
        visual_size = {x = 10, y = 10, z = 10},
        damage_texture_modifier = "",
        selectionbox = {
            -6/16, -0.5, -7/16,
            6/16, -2/16, 7/16
        },
    },
    _invoke = function(e)
        local i = 0
        local function frame()
            e.object:set_rotation(vector.add(e.object:get_rotation(), vector.new(-1 *(15-i) /2, 0, 0):apply(math.rad)))
            e.object:set_pos(vector.add(e.object:get_pos(), vector.new(0, 1/128 *(15-i) /2, 0)))
            i = i + 1
            if i < 17 then minetest.after(0.02, frame) else
                e._active = true
            end
        end
        minetest.after(0.02, frame)
        e.object:set_animation({x=0,y=37}, 25, 0, false)
        minetest.after(1.5, function()
            e._active = true
        end)
    end,
    _dismiss = function(e)
        e._active = false
        local rot = e.object:get_rotation()
        rot.x = -1
        e.object:set_rotation(rot)
        local i = 0
        local function frame()
            local rot = e.object:get_rotation()
            if not rot then return end
            e.object:set_rotation(vector.add(rot, vector.new(math.rad(i/2), 0, 0)))
            e.object:set_pos(vector.add(e.object:get_pos(), vector.new(0, -1/128 *(i) /2, 0)))
            i = i + 1
            if i < 17 then minetest.after(0.02, frame) else
                minetest.swap_node(e._anchor, e._node)
                e.object:remove()
            end
        end
        minetest.after(0.8, frame)
        e.object:set_animation({x=37,y=75}, 25, 0, false)
    end,
    _set_page = function(e, page, noanimate)
        if page < 1 or page > #e._pages + 2 or not noanimate and e._page == page then return end
        local dir = e._page > page
        e._page = math.max(page, 1)
        page = e._page
        if noanimate then
            e.object:set_properties{
                textures = {
                    "libarchive_book.png",
                    e._pages[e._page] and libarchive.rasterize(e._pages[e._page], 512, 640, 32, 32) or "blank.png",
                    e._pages[e._page + 1] and libarchive.rasterize(e._pages[e._page + 1], 512, 640, 32, 32) or "blank.png",
                    "blank.png",
                    "blank.png"
                }
            }
        else
            if dir then
                e.object:set_properties{
                    textures = {
                        "libarchive_book.png",
                        e._pages[e._page] and libarchive.rasterize(e._pages[e._page], 512, 640, 32, 32) or "blank.png",
                        e._pages[e._page + 1] and libarchive.rasterize(e._pages[e._page + 1], 512, 640, 32, 32) or "blank.png",
                        e._pages[e._page + 2] and libarchive.rasterize(e._pages[e._page + 2], 512, 640, 32, 32) or "blank.png",
                        e._pages[e._page + 3] and libarchive.rasterize(e._pages[e._page + 3], 512, 640, 32, 32) or "blank.png",
                    }
                }
                e.object:set_animation({x=90,y=100}, 20, 0, false)
                minetest.after(0.6, function()
                    e.object:set_animation({x=37,y=37}, 20, 0, false)
                    e.object:set_properties{
                        textures = {
                            "libarchive_book.png",
                            e._pages[page] and libarchive.rasterize(e._pages[page], 512, 640, 32, 32) or "blank.png",
                            e._pages[page + 1] and libarchive.rasterize(e._pages[page + 1], 512, 640, 32, 32) or "blank.png",
                            "blank.png",
                            "blank.png"
                        }
                    }
                end)
            else
                e.object:set_properties{
                    textures = {
                        "libarchive_book.png",
                        e._pages[e._page - 2] and libarchive.rasterize(e._pages[e._page - 2], 512, 640, 32, 32) or "blank.png",
                        e._pages[e._page - 1] and libarchive.rasterize(e._pages[e._page - 1], 512, 640, 32, 32) or "blank.png",
                        e._pages[e._page] and libarchive.rasterize(e._pages[e._page], 512, 640, 32, 32) or "blank.png",
                        e._pages[e._page + 1] and libarchive.rasterize(e._pages[e._page + 1], 512, 640, 32, 32) or "blank.png",
                    }
                }
                e.object:set_animation({x=80,y=90}, 20, 0, false)
                minetest.after(0.5, function()
                    e.object:set_animation({x=37,y=37}, 20, 0, false)
                    e.object:set_properties{
                        textures = {
                            "libarchive_book.png",
                            e._pages[e._page] and libarchive.rasterize(e._pages[e._page], 512, 640, 32, 32) or "blank.png",
                            e._pages[e._page + 1] and libarchive.rasterize(e._pages[e._page + 1], 512, 640, 32, 32) or "blank.png",
                            "blank.png",
                            "blank.png"
                        }
                    }
                end)
            end
        end
    end,
    on_activate = function(e, data)
        data = minetest.deserialize(data)
        if not data then
            e.object:remove()
            return
        end
        e.object:set_armor_groups{immortal=1}
        e._anchor = data.anchor
        e._node = data.node
        e._pages = data.pages
        local dir = minetest.facedir_to_dir(data.node.param2)
        e.object:set_yaw(minetest.dir_to_yaw(dir) + math.rad(180))
        --e.object:set_pos(vector.add(e.object:get_pos(), vector.new(0, -15/32, 0)))
        
        e:_set_page(1, true)
        
        e:_invoke()
    end,
    on_step = function(e)
        if not e._active then return end
        local i = 0
        local cd = 999
        local cp = nil
        for _, obj in pairs(minetest.get_objects_inside_radius(e._anchor, 4)) do
            if minetest.is_player(obj) then
                i = i + 1
                local d = vector.length(vector.subtract(obj:get_pos(), e._anchor))
                if d < cd then
                    cd = d
                    cp = obj
                end
            end
        end
        if i == 0 then
            e:_dismiss()
        else
            local rot = e.object:get_rotation()
            rot.x = -vector.dir_to_rotation(vector.subtract(e._anchor, vector.add(cp:get_pos(), vector.new(0,cp:get_properties().eye_height,0)))).x - math.rad(90)
            e.object:set_rotation(rot)
        end
    end,
    on_punch = function(e)
        if not e._active then return end
        e:_dismiss()
    end,
    on_rightclick = function(e, p)
        local pos = p:get_pos()
        pos.y = pos.y + p:get_properties().eye_height
        local rc = minetest.raycast(pos, vector.add(vector.multiply(p:get_look_dir(), 5), pos), true)
        local point = nil
        for x in rc do
            if x.type == "object" and not x.ref:is_player() then
                point = vector.subtract(x.intersection_point, e._anchor)
                break
            end
        end
        if not point then return end
        local dir = minetest.facedir_to_dir(e._node.param2)
        local axis = dir.x ~= 0 and "z" or "x"
        if axis == "z" and dir["x"] < 0 or dir["z"] > 0 then
            if point[axis] > 0 then
                e:_set_page(e._page + 2)
            else
                e:_set_page(e._page - 2)
            end
        else
            if point[axis] < 0 then
                e:_set_page(e._page + 2)
            else
                e:_set_page(e._page - 2)
            end
        end
    end
})
--[[
minetest.register_entity("libarchive:marker", {
    _node = {name="air"},
    _anchor = vector.new(0,0,0),
    _active = false,
    _pages = {""},
    _page = 1,
    initial_properties = {
        visual = "mesh",
        mesh = "libarchive_book.b3d",
        textures = {"libarchive_book.png", "blank.png", "blank.png", "blank.png", "blank.png"},
        visual_size = {x = 10, y = 10, z = 10},
        damage_texture_modifier = "",
        pointable = false,
        selectionbox = {
            -6/16, -0.5, -7/16,
            6/16, -2/16, 7/16
        },
    },
})
--]]

register_node("libarchive:bookshelf", {
    
})
if iteration then minetest.register_alias("it:bookshelf", "libarchive:bookshelf") end

register_node("libarchive:holographic_projector", {
    
})
if iteration then minetest.register_alias("it:holographic_projector", "libarchive:holographic_projector") end


minetest.register_on_player_receive_fields(function(p, form, data)
    if form == "libarchive:noteedit" then
        if data.confirm then
            minetest.get_meta(current_pos[p:get_player_name()]):set_string("libarchive_msg", data.msg)
            current_pos[p:get_player_name()] = nil
        end
        return true
    elseif form == "libarchive:bookedit" then
        local m = bookedit_state[p:get_player_name()]
        m.pages[m.page] = data["msg"..m.page]
        if data.prev then
            m.page = math.max(m.page - 1, 1)
        elseif data.prevf then
            m.page = math.max(m.page - 5, 1)
        end
        if data.next then
            m.page = m.page + 1
            if m.page > #m.pages then table.insert(m.pages, "") end
        elseif data.next then
            m.page = math.min(m.page + 5, m.pages + 1)
            if m.page > #m.pages then table.insert(m.pages, "") end
        end
        if data.confirm then
            minetest.get_meta(m.pos):set_string("libarchive_pages", minetest.serialize(m.pages))
            bookedit_state[p:get_player_name()] = nil
        end
        if not data.quit then
            show_bookedit_formspec(p)
        end
        return true
    end
end)
