
function libarchive.rasterize(str, width, height, px, py)
    local out = "[combine:"..width.."x"..height
    local lh = 32
    local ws = 8
    local x = px or 0
    local y = py or 0
    local b = {}
    local found_space = false
    for chr in str:gmatch"." do
        if chr == " " then
            found_space = true
            x = x + ws
            for _, x in pairs(b) do
                out = out..":"..x.x..","..x.y.."=arial_char_"..x.id..".png\\^[screen\\:#444"
            end
            b = {}
            goto continue
        end
        if chr == "\n" then
            for _, x in pairs(b) do
                out = out..":"..x.x..","..x.y.."=arial_char_"..x.id..".png\\^[screen\\:#444"
            end
            b = {}
            y = y + lh
            x = px or 0
            goto continue
        end
        local cd = libarchive.fonts.arial24_bold.characters[chr] or libarchive.fonts.arial24_bold.characters["?"]
        if x + cd.width > width - px then
            if not found_space then
                for _, x in pairs(b) do
                    out = out..":"..x.x..","..x.y.."=arial_char_"..x.id..".png\\^[screen\\:#444"
                end
                b = {}
            end
            x = px or 0
            y = y + lh
            for _, c in pairs(b) do
                c.x = x
                c.y = y + (lh - c.cd.height) + c.offset
                --out = out..":"..x.x..","..x.y.."=arial_char_"..x.id..".png\\^[screen\\:#444"
                x = x + c.cd.width
            end
        end
        if y > height - py then break end
        local offset = 0
        if chr:match"[qypjg]" then
            offset = 5
        elseif chr:match"[,]" then
            offset = 3
        elseif chr:match"[\"'`^]" then
            offset = -14
        elseif chr:match"[~*+-=]" then
            offset = -4
        end
        b[#b + 1] = {cd = cd, id = chr:byte(1), x = x, y = y + (lh - cd.height) + offset, offset = offset}
        --out = out..":"..x..","..y + (lh - cd.height).."=arial_char_"..chr:byte(1)..".png\\^[screen\\:#444"
        x = x + cd.width
        ::continue::
    end
    for _, x in pairs(b) do
        out = out..":"..x.x..","..x.y.."=arial_char_"..x.id..".png\\^[screen\\:#444"
    end
   return out
end

libarchive.fonts = {
    arial24 =     {
      ["name"] =  "Arial",
      ["size"] =  24,
      ["bold"] =  false,
      ["italic"] =  false,
      ["width"] =  272,
      ["height"] =  102,
      ["characters"] =  {
        ["0"] = {["x"] = 0,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["1"] = {["x"] = 82,["y"] = 67,["width"] = 10,["height"] = 20,["originX"] = -1,["originY"] = 19,["advance"] = 13},
        ["2"] = {["x"] = 207,["y"] = 47,["width"] = 15,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["3"] = {["x"] = 15,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["4"] = {["x"] = 222,["y"] = 47,["width"] = 15,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["5"] = {["x"] = 30,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["6"] = {["x"] = 45,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["7"] = {["x"] = 0,["y"] = 67,["width"] = 14,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 13},
        ["8"] = {["x"] = 60,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["9"] = {["x"] = 75,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        [" "] = {["x"] = 214,["y"] = 87,["width"] = 3,["height"] = 3,["originX"] = 1,["originY"] = 1,["advance"] = 7},
        ["!"] = {["x"] = 102,["y"] = 67,["width"] = 6,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 7},
        ["\""] = {["x"] = 136,["y"] = 87,["width"] = 10,["height"] = 9,["originX"] = 1,["originY"] = 19,["advance"] = 9},
        ["#"] = {["x"] = 256,["y"] = 0,["width"] = 16,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["$"] = {["x"] = 76,["y"] = 0,["width"] = 15,["height"] = 25,["originX"] = 1,["originY"] = 21,["advance"] = 13},
        ["%"] = {["x"] = 127,["y"] = 0,["width"] = 21,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 21},
        ["&"] = {["x"] = 186,["y"] = 0,["width"] = 18,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 16},
        ["'"] = {["x"] = 146,["y"] = 87,["width"] = 6,["height"] = 9,["originX"] = 1,["originY"] = 19,["advance"] = 5},
        ["("] = {["x"] = 45,["y"] = 0,["width"] = 9,["height"] = 26,["originX"] = 0,["originY"] = 19,["advance"] = 8},
        [")"] = {["x"] = 54,["y"] = 0,["width"] = 9,["height"] = 26,["originX"] = 0,["originY"] = 19,["advance"] = 8},
        ["*"] = {["x"] = 125,["y"] = 87,["width"] = 11,["height"] = 10,["originX"] = 1,["originY"] = 19,["advance"] = 9},
        ["+"] = {["x"] = 256,["y"] = 67,["width"] = 14,["height"] = 15,["originX"] = 0,["originY"] = 16,["advance"] = 14},
        [","] = {["x"] = 152,["y"] = 87,["width"] = 6,["height"] = 9,["originX"] = 0,["originY"] = 4,["advance"] = 7},
        ["-"] = {["x"] = 199,["y"] = 87,["width"] = 10,["height"] = 5,["originX"] = 1,["originY"] = 9,["advance"] = 8},
        ["."] = {["x"] = 209,["y"] = 87,["width"] = 5,["height"] = 5,["originX"] = -1,["originY"] = 4,["advance"] = 7},
        ["/"] = {["x"] = 159,["y"] = 26,["width"] = 10,["height"] = 21,["originX"] = 2,["originY"] = 19,["advance"] = 7},
        [":"] = {["x"] = 93,["y"] = 87,["width"] = 5,["height"] = 15,["originX"] = -1,["originY"] = 14,["advance"] = 7},
        [";"] = {["x"] = 123,["y"] = 67,["width"] = 6,["height"] = 19,["originX"] = 0,["originY"] = 14,["advance"] = 7},
        ["<"] = {["x"] = 0,["y"] = 87,["width"] = 14,["height"] = 15,["originX"] = 0,["originY"] = 16,["advance"] = 14},
        ["="] = {["x"] = 111,["y"] = 87,["width"] = 14,["height"] = 11,["originX"] = 0,["originY"] = 14,["advance"] = 14},
        [">"] = {["x"] = 14,["y"] = 87,["width"] = 14,["height"] = 15,["originX"] = 0,["originY"] = 16,["advance"] = 14},
        ["?"] = {["x"] = 237,["y"] = 47,["width"] = 15,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["@"] = {["x"] = 0,["y"] = 0,["width"] = 25,["height"] = 26,["originX"] = 0,["originY"] = 19,["advance"] = 24},
        ["A"] = {["x"] = 213,["y"] = 26,["width"] = 20,["height"] = 20,["originX"] = 2,["originY"] = 19,["advance"] = 16},
        ["B"] = {["x"] = 175,["y"] = 47,["width"] = 16,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 16},
        ["C"] = {["x"] = 204,["y"] = 0,["width"] = 18,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["D"] = {["x"] = 0,["y"] = 47,["width"] = 18,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["E"] = {["x"] = 191,["y"] = 47,["width"] = 16,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 16},
        ["F"] = {["x"] = 252,["y"] = 47,["width"] = 15,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 15},
        ["G"] = {["x"] = 148,["y"] = 0,["width"] = 19,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 19},
        ["H"] = {["x"] = 90,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["I"] = {["x"] = 108,["y"] = 67,["width"] = 5,["height"] = 20,["originX"] = -1,["originY"] = 19,["advance"] = 7},
        ["J"] = {["x"] = 146,["y"] = 26,["width"] = 13,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 12},
        ["K"] = {["x"] = 18,["y"] = 47,["width"] = 18,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 16},
        ["L"] = {["x"] = 14,["y"] = 67,["width"] = 14,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 13},
        ["M"] = {["x"] = 233,["y"] = 26,["width"] = 20,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 20},
        ["N"] = {["x"] = 107,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["O"] = {["x"] = 167,["y"] = 0,["width"] = 19,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 19},
        ["P"] = {["x"] = 124,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 16},
        ["Q"] = {["x"] = 107,["y"] = 0,["width"] = 20,["height"] = 22,["originX"] = 1,["originY"] = 19,["advance"] = 19},
        ["R"] = {["x"] = 253,["y"] = 26,["width"] = 19,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["S"] = {["x"] = 222,["y"] = 0,["width"] = 17,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 16},
        ["T"] = {["x"] = 141,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 15},
        ["U"] = {["x"] = 239,["y"] = 0,["width"] = 17,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["V"] = {["x"] = 36,["y"] = 47,["width"] = 18,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 16},
        ["W"] = {["x"] = 188,["y"] = 26,["width"] = 25,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 23},
        ["X"] = {["x"] = 54,["y"] = 47,["width"] = 18,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 16},
        ["Y"] = {["x"] = 72,["y"] = 47,["width"] = 18,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 16},
        ["Z"] = {["x"] = 158,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 15},
        ["["] = {["x"] = 91,["y"] = 0,["width"] = 8,["height"] = 25,["originX"] = 0,["originY"] = 19,["advance"] = 7},
        ["\\"] = {["x"] = 169,["y"] = 26,["width"] = 10,["height"] = 21,["originX"] = 2,["originY"] = 19,["advance"] = 7},
        ["]"] = {["x"] = 99,["y"] = 0,["width"] = 8,["height"] = 25,["originX"] = 1,["originY"] = 19,["advance"] = 7},
        ["^"] = {["x"] = 98,["y"] = 87,["width"] = 13,["height"] = 12,["originX"] = 1,["originY"] = 19,["advance"] = 11},
        ["_"] = {["x"] = 182,["y"] = 87,["width"] = 17,["height"] = 5,["originX"] = 2,["originY"] = -1,["advance"] = 13},
        ["`"] = {["x"] = 174,["y"] = 87,["width"] = 8,["height"] = 7,["originX"] = 1,["originY"] = 19,["advance"] = 8},
        ["a"] = {["x"] = 129,["y"] = 67,["width"] = 15,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["b"] = {["x"] = 90,["y"] = 26,["width"] = 14,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 13},
        ["c"] = {["x"] = 174,["y"] = 67,["width"] = 14,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 12},
        ["d"] = {["x"] = 104,["y"] = 26,["width"] = 14,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["e"] = {["x"] = 144,["y"] = 67,["width"] = 15,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["f"] = {["x"] = 92,["y"] = 67,["width"] = 10,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 7},
        ["g"] = {["x"] = 118,["y"] = 26,["width"] = 14,["height"] = 21,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["h"] = {["x"] = 56,["y"] = 67,["width"] = 13,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 13},
        ["i"] = {["x"] = 113,["y"] = 67,["width"] = 5,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 5},
        ["j"] = {["x"] = 63,["y"] = 0,["width"] = 8,["height"] = 26,["originX"] = 3,["originY"] = 19,["advance"] = 5},
        ["k"] = {["x"] = 69,["y"] = 67,["width"] = 13,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 12},
        ["l"] = {["x"] = 118,["y"] = 67,["width"] = 5,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 5},
        ["m"] = {["x"] = 236,["y"] = 67,["width"] = 20,["height"] = 15,["originX"] = 0,["originY"] = 14,["advance"] = 20},
        ["n"] = {["x"] = 70,["y"] = 87,["width"] = 13,["height"] = 15,["originX"] = 0,["originY"] = 14,["advance"] = 13},
        ["o"] = {["x"] = 159,["y"] = 67,["width"] = 15,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["p"] = {["x"] = 28,["y"] = 67,["width"] = 14,["height"] = 20,["originX"] = 0,["originY"] = 14,["advance"] = 13},
        ["q"] = {["x"] = 42,["y"] = 67,["width"] = 14,["height"] = 20,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["r"] = {["x"] = 83,["y"] = 87,["width"] = 10,["height"] = 15,["originX"] = 0,["originY"] = 14,["advance"] = 8},
        ["s"] = {["x"] = 188,["y"] = 67,["width"] = 14,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 12},
        ["t"] = {["x"] = 179,["y"] = 26,["width"] = 9,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 7},
        ["u"] = {["x"] = 202,["y"] = 67,["width"] = 13,["height"] = 16,["originX"] = 0,["originY"] = 14,["advance"] = 13},
        ["v"] = {["x"] = 28,["y"] = 87,["width"] = 14,["height"] = 15,["originX"] = 1,["originY"] = 14,["advance"] = 12},
        ["w"] = {["x"] = 215,["y"] = 67,["width"] = 21,["height"] = 15,["originX"] = 2,["originY"] = 14,["advance"] = 17},
        ["x"] = {["x"] = 42,["y"] = 87,["width"] = 14,["height"] = 15,["originX"] = 1,["originY"] = 14,["advance"] = 12},
        ["y"] = {["x"] = 132,["y"] = 26,["width"] = 14,["height"] = 21,["originX"] = 1,["originY"] = 14,["advance"] = 12},
        ["z"] = {["x"] = 56,["y"] = 87,["width"] = 14,["height"] = 15,["originX"] = 1,["originY"] = 14,["advance"] = 12},
        ["{"] = {["x"] = 25,["y"] = 0,["width"] = 10,["height"] = 26,["originX"] = 1,["originY"] = 19,["advance"] = 8},
        ["|"] = {["x"] = 71,["y"] = 0,["width"] = 5,["height"] = 26,["originX"] = -1,["originY"] = 19,["advance"] = 6},
        ["}"] = {["x"] = 35,["y"] = 0,["width"] = 10,["height"] = 26,["originX"] = 1,["originY"] = 19,["advance"] = 8},
        ["~"] = {["x"] = 158,["y"] = 87,["width"] = 16,["height"] = 7,["originX"] = 1,["originY"] = 12,["advance"] = 14}
      }
    },
    arial24_bold =     {
      ["name"] =  "Arial",
      ["size"] =  24,
      ["bold"] =  true,
      ["italic"] =  false,
      ["width"] =  284,
      ["height"] =  102,
      ["characters"] =  {
        ["0"] = {["x"] = 64,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["1"] = {["x"] = 105,["y"] = 67,["width"] = 11,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 13},
        ["2"] = {["x"] = 267,["y"] = 47,["width"] = 15,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["3"] = {["x"] = 79,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["4"] = {["x"] = 0,["y"] = 67,["width"] = 15,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["5"] = {["x"] = 94,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["6"] = {["x"] = 109,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["7"] = {["x"] = 15,["y"] = 67,["width"] = 15,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["8"] = {["x"] = 124,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["9"] = {["x"] = 139,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        [" "] = {["x"] = 260,["y"] = 87,["width"] = 3,["height"] = 3,["originX"] = 1,["originY"] = 1,["advance"] = 7},
        ["!"] = {["x"] = 148,["y"] = 67,["width"] = 6,["height"] = 20,["originX"] = -1,["originY"] = 19,["advance"] = 8},
        ["\""] = {["x"] = 184,["y"] = 87,["width"] = 12,["height"] = 9,["originX"] = 0,["originY"] = 19,["advance"] = 11},
        ["#"] = {["x"] = 0,["y"] = 26,["width"] = 16,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["$"] = {["x"] = 100,["y"] = 0,["width"] = 15,["height"] = 24,["originX"] = 1,["originY"] = 20,["advance"] = 13},
        ["%"] = {["x"] = 136,["y"] = 0,["width"] = 23,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 21},
        ["&"] = {["x"] = 159,["y"] = 0,["width"] = 20,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 17},
        ["'"] = {["x"] = 196,["y"] = 87,["width"] = 7,["height"] = 9,["originX"] = 1,["originY"] = 19,["advance"] = 6},
        ["("] = {["x"] = 58,["y"] = 0,["width"] = 9,["height"] = 26,["originX"] = 0,["originY"] = 19,["advance"] = 8},
        [")"] = {["x"] = 67,["y"] = 0,["width"] = 9,["height"] = 26,["originX"] = 1,["originY"] = 19,["advance"] = 8},
        ["*"] = {["x"] = 166,["y"] = 87,["width"] = 11,["height"] = 11,["originX"] = 1,["originY"] = 19,["advance"] = 9},
        ["+"] = {["x"] = 42,["y"] = 87,["width"] = 16,["height"] = 15,["originX"] = 1,["originY"] = 16,["advance"] = 14},
        [","] = {["x"] = 177,["y"] = 87,["width"] = 7,["height"] = 10,["originX"] = 0,["originY"] = 5,["advance"] = 7},
        ["-"] = {["x"] = 219,["y"] = 87,["width"] = 9,["height"] = 7,["originX"] = 0,["originY"] = 10,["advance"] = 8},
        ["."] = {["x"] = 236,["y"] = 87,["width"] = 7,["height"] = 6,["originX"] = 0,["originY"] = 5,["advance"] = 7},
        ["/"] = {["x"] = 183,["y"] = 26,["width"] = 10,["height"] = 21,["originX"] = 2,["originY"] = 19,["advance"] = 7},
        [":"] = {["x"] = 130,["y"] = 87,["width"] = 6,["height"] = 15,["originX"] = -1,["originY"] = 14,["advance"] = 8},
        [";"] = {["x"] = 154,["y"] = 67,["width"] = 7,["height"] = 19,["originX"] = 0,["originY"] = 14,["advance"] = 8},
        ["<"] = {["x"] = 161,["y"] = 67,["width"] = 16,["height"] = 16,["originX"] = 1,["originY"] = 17,["advance"] = 14},
        ["="] = {["x"] = 150,["y"] = 87,["width"] = 16,["height"] = 11,["originX"] = 1,["originY"] = 14,["advance"] = 14},
        [">"] = {["x"] = 177,["y"] = 67,["width"] = 16,["height"] = 16,["originX"] = 1,["originY"] = 17,["advance"] = 14},
        ["?"] = {["x"] = 30,["y"] = 67,["width"] = 15,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 15},
        ["@"] = {["x"] = 0,["y"] = 0,["width"] = 26,["height"] = 26,["originX"] = 1,["originY"] = 19,["advance"] = 23},
        ["A"] = {["x"] = 238,["y"] = 26,["width"] = 21,["height"] = 20,["originX"] = 2,["originY"] = 19,["advance"] = 17},
        ["B"] = {["x"] = 98,["y"] = 47,["width"] = 18,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["C"] = {["x"] = 218,["y"] = 0,["width"] = 18,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["D"] = {["x"] = 116,["y"] = 47,["width"] = 18,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["E"] = {["x"] = 219,["y"] = 47,["width"] = 16,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 16},
        ["F"] = {["x"] = 45,["y"] = 67,["width"] = 15,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 15},
        ["G"] = {["x"] = 199,["y"] = 0,["width"] = 19,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 19},
        ["H"] = {["x"] = 134,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["I"] = {["x"] = 127,["y"] = 67,["width"] = 7,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 7},
        ["J"] = {["x"] = 169,["y"] = 26,["width"] = 14,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 13},
        ["K"] = {["x"] = 60,["y"] = 47,["width"] = 19,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["L"] = {["x"] = 235,["y"] = 47,["width"] = 16,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 15},
        ["M"] = {["x"] = 259,["y"] = 26,["width"] = 20,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 20},
        ["N"] = {["x"] = 151,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["O"] = {["x"] = 179,["y"] = 0,["width"] = 20,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 19},
        ["P"] = {["x"] = 168,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 16},
        ["Q"] = {["x"] = 115,["y"] = 0,["width"] = 21,["height"] = 22,["originX"] = 1,["originY"] = 19,["advance"] = 19},
        ["R"] = {["x"] = 79,["y"] = 47,["width"] = 19,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["S"] = {["x"] = 236,["y"] = 0,["width"] = 17,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 16},
        ["T"] = {["x"] = 185,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 15},
        ["U"] = {["x"] = 253,["y"] = 0,["width"] = 17,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 17},
        ["V"] = {["x"] = 0,["y"] = 47,["width"] = 20,["height"] = 20,["originX"] = 2,["originY"] = 19,["advance"] = 16},
        ["W"] = {["x"] = 213,["y"] = 26,["width"] = 25,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 23},
        ["X"] = {["x"] = 20,["y"] = 47,["width"] = 20,["height"] = 20,["originX"] = 2,["originY"] = 19,["advance"] = 16},
        ["Y"] = {["x"] = 40,["y"] = 47,["width"] = 20,["height"] = 20,["originX"] = 2,["originY"] = 19,["advance"] = 16},
        ["Z"] = {["x"] = 202,["y"] = 47,["width"] = 17,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 15},
        ["["] = {["x"] = 82,["y"] = 0,["width"] = 9,["height"] = 25,["originX"] = 0,["originY"] = 19,["advance"] = 8},
        ["\\"] = {["x"] = 193,["y"] = 26,["width"] = 10,["height"] = 21,["originX"] = 2,["originY"] = 19,["advance"] = 7},
        ["]"] = {["x"] = 91,["y"] = 0,["width"] = 9,["height"] = 25,["originX"] = 1,["originY"] = 19,["advance"] = 8},
        ["^"] = {["x"] = 136,["y"] = 87,["width"] = 14,["height"] = 12,["originX"] = 0,["originY"] = 19,["advance"] = 14},
        ["_"] = {["x"] = 243,["y"] = 87,["width"] = 17,["height"] = 5,["originX"] = 2,["originY"] = -1,["advance"] = 13},
        ["`"] = {["x"] = 228,["y"] = 87,["width"] = 8,["height"] = 7,["originX"] = 1,["originY"] = 19,["advance"] = 8},
        ["a"] = {["x"] = 209,["y"] = 67,["width"] = 15,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["b"] = {["x"] = 154,["y"] = 26,["width"] = 15,["height"] = 21,["originX"] = 0,["originY"] = 19,["advance"] = 15},
        ["c"] = {["x"] = 224,["y"] = 67,["width"] = 15,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["d"] = {["x"] = 16,["y"] = 26,["width"] = 16,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 15},
        ["e"] = {["x"] = 239,["y"] = 67,["width"] = 15,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["f"] = {["x"] = 116,["y"] = 67,["width"] = 11,["height"] = 20,["originX"] = 1,["originY"] = 19,["advance"] = 8},
        ["g"] = {["x"] = 32,["y"] = 26,["width"] = 16,["height"] = 21,["originX"] = 1,["originY"] = 14,["advance"] = 15},
        ["h"] = {["x"] = 60,["y"] = 67,["width"] = 15,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 15},
        ["i"] = {["x"] = 134,["y"] = 67,["width"] = 7,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 7},
        ["j"] = {["x"] = 48,["y"] = 0,["width"] = 10,["height"] = 26,["originX"] = 3,["originY"] = 19,["advance"] = 7},
        ["k"] = {["x"] = 75,["y"] = 67,["width"] = 15,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 13},
        ["l"] = {["x"] = 141,["y"] = 67,["width"] = 7,["height"] = 20,["originX"] = 0,["originY"] = 19,["advance"] = 7},
        ["m"] = {["x"] = 0,["y"] = 87,["width"] = 21,["height"] = 15,["originX"] = 0,["originY"] = 14,["advance"] = 21},
        ["n"] = {["x"] = 90,["y"] = 87,["width"] = 15,["height"] = 15,["originX"] = 0,["originY"] = 14,["advance"] = 15},
        ["o"] = {["x"] = 193,["y"] = 67,["width"] = 16,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 15},
        ["p"] = {["x"] = 90,["y"] = 67,["width"] = 15,["height"] = 20,["originX"] = 0,["originY"] = 14,["advance"] = 15},
        ["q"] = {["x"] = 251,["y"] = 47,["width"] = 16,["height"] = 20,["originX"] = 1,["originY"] = 14,["advance"] = 15},
        ["r"] = {["x"] = 119,["y"] = 87,["width"] = 11,["height"] = 15,["originX"] = 0,["originY"] = 14,["advance"] = 9},
        ["s"] = {["x"] = 254,["y"] = 67,["width"] = 15,["height"] = 16,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["t"] = {["x"] = 203,["y"] = 26,["width"] = 10,["height"] = 21,["originX"] = 1,["originY"] = 19,["advance"] = 8},
        ["u"] = {["x"] = 269,["y"] = 67,["width"] = 15,["height"] = 16,["originX"] = 0,["originY"] = 14,["advance"] = 15},
        ["v"] = {["x"] = 58,["y"] = 87,["width"] = 16,["height"] = 15,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["w"] = {["x"] = 21,["y"] = 87,["width"] = 21,["height"] = 15,["originX"] = 1,["originY"] = 14,["advance"] = 19},
        ["x"] = {["x"] = 74,["y"] = 87,["width"] = 16,["height"] = 15,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["y"] = {["x"] = 48,["y"] = 26,["width"] = 16,["height"] = 21,["originX"] = 1,["originY"] = 14,["advance"] = 13},
        ["z"] = {["x"] = 105,["y"] = 87,["width"] = 14,["height"] = 15,["originX"] = 1,["originY"] = 14,["advance"] = 12},
        ["{"] = {["x"] = 26,["y"] = 0,["width"] = 11,["height"] = 26,["originX"] = 1,["originY"] = 19,["advance"] = 9},
        ["|"] = {["x"] = 76,["y"] = 0,["width"] = 6,["height"] = 26,["originX"] = 0,["originY"] = 19,["advance"] = 7},
        ["}"] = {["x"] = 37,["y"] = 0,["width"] = 11,["height"] = 26,["originX"] = 1,["originY"] = 19,["advance"] = 9},
        ["~"] = {["x"] = 203,["y"] = 87,["width"] = 16,["height"] = 8,["originX"] = 1,["originY"] = 13,["advance"] = 14}
      }
    },
    arial =     {
          ["name"] =  "Arial",
          ["size"] =  12,
          ["bold"] =  false,
          ["italic"] =  false,
          ["width"] =  146,
          ["height"] =  68,
          ["characters"] =  {
            ["0"] = {["x"] = 31,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["1"] = {["x"] = 8,["y"] = 28,["width"] = 6,["height"] = 12,["originX"] = 0,["originY"] = 11,["advance"] = 7},
            ["2"] = {["x"] = 50,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["3"] = {["x"] = 40,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["4"] = {["x"] = 59,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["5"] = {["x"] = 49,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["6"] = {["x"] = 58,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["7"] = {["x"] = 68,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["8"] = {["x"] = 67,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["9"] = {["x"] = 76,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            [" "] = {["x"] = 65,["y"] = 61,["width"] = 3,["height"] = 3,["originX"] = 1,["originY"] = 1,["advance"] = 3},
            ["!"] = {["x"] = 111,["y"] = 40,["width"] = 5,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 3},
            ["\""] = {["x"] = 16,["y"] = 61,["width"] = 6,["height"] = 6,["originX"] = 1,["originY"] = 10,["advance"] = 4},
            ["#"] = {["x"] = 0,["y"] = 15,["width"] = 9,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 7},
            ["$"] = {["x"] = 42,["y"] = 0,["width"] = 9,["height"] = 14,["originX"] = 1,["originY"] = 11,["advance"] = 7},
            ["%"] = {["x"] = 67,["y"] = 0,["width"] = 12,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 11},
            ["&"] = {["x"] = 123,["y"] = 0,["width"] = 10,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 8},
            ["'"] = {["x"] = 27,["y"] = 61,["width"] = 4,["height"] = 6,["originX"] = 1,["originY"] = 10,["advance"] = 2},
            ["("] = {["x"] = 14,["y"] = 0,["width"] = 6,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 4},
            [")"] = {["x"] = 20,["y"] = 0,["width"] = 6,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 4},
            ["*"] = {["x"] = 9,["y"] = 61,["width"] = 7,["height"] = 7,["originX"] = 1,["originY"] = 11,["advance"] = 5},
            ["+"] = {["x"] = 65,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 9,["advance"] = 7},
            [","] = {["x"] = 22,["y"] = 61,["width"] = 5,["height"] = 6,["originX"] = 1,["originY"] = 3,["advance"] = 3},
            ["-"] = {["x"] = 40,["y"] = 61,["width"] = 6,["height"] = 5,["originX"] = 1,["originY"] = 6,["advance"] = 4},
            ["."] = {["x"] = 61,["y"] = 61,["width"] = 4,["height"] = 4,["originX"] = 0,["originY"] = 3,["advance"] = 3},
            ["/"] = {["x"] = 9,["y"] = 15,["width"] = 6,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 3},
            [":"] = {["x"] = 131,["y"] = 51,["width"] = 4,["height"] = 9,["originX"] = 0,["originY"] = 8,["advance"] = 3},
            [";"] = {["x"] = 116,["y"] = 40,["width"] = 5,["height"] = 11,["originX"] = 1,["originY"] = 8,["advance"] = 3},
            ["<"] = {["x"] = 74,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 9,["advance"] = 7},
            ["="] = {["x"] = 0,["y"] = 61,["width"] = 9,["height"] = 7,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            [">"] = {["x"] = 83,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 9,["advance"] = 7},
            ["?"] = {["x"] = 85,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 11,["advance"] = 7},
            ["@"] = {["x"] = 0,["y"] = 0,["width"] = 14,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 12},
            ["A"] = {["x"] = 40,["y"] = 28,["width"] = 12,["height"] = 11,["originX"] = 2,["originY"] = 10,["advance"] = 8},
            ["B"] = {["x"] = 86,["y"] = 28,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
            ["C"] = {["x"] = 79,["y"] = 0,["width"] = 11,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
            ["D"] = {["x"] = 64,["y"] = 28,["width"] = 11,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
            ["E"] = {["x"] = 96,["y"] = 28,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
            ["F"] = {["x"] = 77,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["G"] = {["x"] = 90,["y"] = 0,["width"] = 11,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
            ["H"] = {["x"] = 106,["y"] = 28,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
            ["I"] = {["x"] = 121,["y"] = 40,["width"] = 4,["height"] = 11,["originX"] = 0,["originY"] = 10,["advance"] = 3},
            ["J"] = {["x"] = 112,["y"] = 15,["width"] = 8,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 6},
            ["K"] = {["x"] = 116,["y"] = 28,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
            ["L"] = {["x"] = 86,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["M"] = {["x"] = 52,["y"] = 28,["width"] = 12,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 10},
            ["N"] = {["x"] = 126,["y"] = 28,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
            ["O"] = {["x"] = 101,["y"] = 0,["width"] = 11,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
            ["P"] = {["x"] = 136,["y"] = 28,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
            ["Q"] = {["x"] = 112,["y"] = 0,["width"] = 11,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
            ["R"] = {["x"] = 75,["y"] = 28,["width"] = 11,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
            ["S"] = {["x"] = 133,["y"] = 0,["width"] = 10,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 8},
            ["T"] = {["x"] = 0,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["U"] = {["x"] = 21,["y"] = 15,["width"] = 10,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 9},
            ["V"] = {["x"] = 10,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
            ["W"] = {["x"] = 26,["y"] = 28,["width"] = 14,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 11},
            ["X"] = {["x"] = 20,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
            ["Y"] = {["x"] = 30,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
            ["Z"] = {["x"] = 40,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["["] = {["x"] = 51,["y"] = 0,["width"] = 6,["height"] = 14,["originX"] = 1,["originY"] = 10,["advance"] = 3},
            ["\\"] = {["x"] = 15,["y"] = 15,["width"] = 6,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 3},
            ["]"] = {["x"] = 57,["y"] = 0,["width"] = 5,["height"] = 14,["originX"] = 1,["originY"] = 10,["advance"] = 3},
            ["^"] = {["x"] = 135,["y"] = 51,["width"] = 8,["height"] = 8,["originX"] = 1,["originY"] = 11,["advance"] = 6},
            ["_"] = {["x"] = 51,["y"] = 61,["width"] = 10,["height"] = 4,["originX"] = 2,["originY"] = 0,["advance"] = 7},
            ["`"] = {["x"] = 46,["y"] = 61,["width"] = 5,["height"] = 5,["originX"] = 1,["originY"] = 11,["advance"] = 4},
            ["a"] = {["x"] = 133,["y"] = 40,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            ["b"] = {["x"] = 94,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["c"] = {["x"] = 18,["y"] = 51,["width"] = 8,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 6},
            ["d"] = {["x"] = 120,["y"] = 15,["width"] = 8,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["e"] = {["x"] = 0,["y"] = 51,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            ["f"] = {["x"] = 14,["y"] = 28,["width"] = 6,["height"] = 12,["originX"] = 1,["originY"] = 11,["advance"] = 3},
            ["g"] = {["x"] = 128,["y"] = 15,["width"] = 8,["height"] = 12,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            ["h"] = {["x"] = 95,["y"] = 40,["width"] = 8,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
            ["i"] = {["x"] = 125,["y"] = 40,["width"] = 4,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 3},
            ["j"] = {["x"] = 62,["y"] = 0,["width"] = 5,["height"] = 14,["originX"] = 2,["originY"] = 10,["advance"] = 3},
            ["k"] = {["x"] = 103,["y"] = 40,["width"] = 8,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 6},
            ["l"] = {["x"] = 129,["y"] = 40,["width"] = 4,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 3},
            ["m"] = {["x"] = 42,["y"] = 51,["width"] = 12,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 10},
            ["n"] = {["x"] = 92,["y"] = 51,["width"] = 8,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            ["o"] = {["x"] = 9,["y"] = 51,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            ["p"] = {["x"] = 103,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            ["q"] = {["x"] = 136,["y"] = 15,["width"] = 8,["height"] = 12,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            ["r"] = {["x"] = 124,["y"] = 51,["width"] = 7,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 4},
            ["s"] = {["x"] = 26,["y"] = 51,["width"] = 8,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 6},
            ["t"] = {["x"] = 20,["y"] = 28,["width"] = 6,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 3},
            ["u"] = {["x"] = 34,["y"] = 51,["width"] = 8,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
            ["v"] = {["x"] = 100,["y"] = 51,["width"] = 8,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 6},
            ["w"] = {["x"] = 54,["y"] = 51,["width"] = 11,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 9},
            ["x"] = {["x"] = 108,["y"] = 51,["width"] = 8,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 6},
            ["y"] = {["x"] = 0,["y"] = 28,["width"] = 8,["height"] = 12,["originX"] = 1,["originY"] = 8,["advance"] = 6},
            ["z"] = {["x"] = 116,["y"] = 51,["width"] = 8,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 6},
            ["{"] = {["x"] = 26,["y"] = 0,["width"] = 6,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 4},
            ["|"] = {["x"] = 38,["y"] = 0,["width"] = 4,["height"] = 15,["originX"] = 0,["originY"] = 11,["advance"] = 3},
            ["}"] = {["x"] = 32,["y"] = 0,["width"] = 6,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 4},
            ["~"] = {["x"] = 31,["y"] = 61,["width"] = 9,["height"] = 5,["originX"] = 1,["originY"] = 7,["advance"] = 7}
          }
        },
    arial_bold =     {
      ["name"] =  "Arial",
      ["size"] =  12,
      ["bold"] =  true,
      ["italic"] =  false,
      ["width"] =  151,
      ["height"] =  69,
      ["characters"] =  {
        ["0"] = {["x"] = 33,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["1"] = {["x"] = 17,["y"] = 28,["width"] = 7,["height"] = 12,["originX"] = 1,["originY"] = 11,["advance"] = 7},
        ["2"] = {["x"] = 80,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["3"] = {["x"] = 42,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["4"] = {["x"] = 51,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 11,["advance"] = 7},
        ["5"] = {["x"] = 60,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["6"] = {["x"] = 69,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["7"] = {["x"] = 89,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["8"] = {["x"] = 78,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["9"] = {["x"] = 87,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        [" "] = {["x"] = 78,["y"] = 61,["width"] = 3,["height"] = 3,["originX"] = 1,["originY"] = 1,["advance"] = 3},
        ["!"] = {["x"] = 145,["y"] = 40,["width"] = 4,["height"] = 11,["originX"] = 0,["originY"] = 10,["advance"] = 4},
        ["\""] = {["x"] = 25,["y"] = 61,["width"] = 8,["height"] = 6,["originX"] = 1,["originY"] = 10,["advance"] = 6},
        ["#"] = {["x"] = 0,["y"] = 15,["width"] = 9,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 7},
        ["$"] = {["x"] = 45,["y"] = 0,["width"] = 9,["height"] = 14,["originX"] = 1,["originY"] = 11,["advance"] = 7},
        ["%"] = {["x"] = 72,["y"] = 0,["width"] = 13,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 11},
        ["&"] = {["x"] = 97,["y"] = 0,["width"] = 11,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
        ["'"] = {["x"] = 33,["y"] = 61,["width"] = 5,["height"] = 6,["originX"] = 1,["originY"] = 10,["advance"] = 3},
        ["("] = {["x"] = 28,["y"] = 0,["width"] = 6,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 4},
        [")"] = {["x"] = 34,["y"] = 0,["width"] = 6,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 4},
        ["*"] = {["x"] = 18,["y"] = 61,["width"] = 7,["height"] = 7,["originX"] = 1,["originY"] = 11,["advance"] = 5},
        ["+"] = {["x"] = 78,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 9,["advance"] = 7},
        [","] = {["x"] = 38,["y"] = 61,["width"] = 5,["height"] = 6,["originX"] = 1,["originY"] = 3,["advance"] = 3},
        ["-"] = {["x"] = 52,["y"] = 61,["width"] = 6,["height"] = 5,["originX"] = 1,["originY"] = 6,["advance"] = 4},
        ["."] = {["x"] = 73,["y"] = 61,["width"] = 5,["height"] = 4,["originX"] = 1,["originY"] = 3,["advance"] = 3},
        ["/"] = {["x"] = 9,["y"] = 15,["width"] = 7,["height"] = 13,["originX"] = 2,["originY"] = 11,["advance"] = 3},
        [":"] = {["x"] = 147,["y"] = 51,["width"] = 4,["height"] = 9,["originX"] = 0,["originY"] = 8,["advance"] = 4},
        [";"] = {["x"] = 125,["y"] = 40,["width"] = 5,["height"] = 11,["originX"] = 1,["originY"] = 8,["advance"] = 4},
        ["<"] = {["x"] = 87,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 9,["advance"] = 7},
        ["="] = {["x"] = 9,["y"] = 61,["width"] = 9,["height"] = 7,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        [">"] = {["x"] = 96,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 9,["advance"] = 7},
        ["?"] = {["x"] = 96,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 11,["advance"] = 7},
        ["@"] = {["x"] = 0,["y"] = 0,["width"] = 14,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 12},
        ["A"] = {["x"] = 87,["y"] = 28,["width"] = 11,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
        ["B"] = {["x"] = 98,["y"] = 28,["width"] = 11,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
        ["C"] = {["x"] = 108,["y"] = 0,["width"] = 11,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
        ["D"] = {["x"] = 109,["y"] = 28,["width"] = 11,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
        ["E"] = {["x"] = 0,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
        ["F"] = {["x"] = 98,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["G"] = {["x"] = 119,["y"] = 0,["width"] = 11,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
        ["H"] = {["x"] = 10,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
        ["I"] = {["x"] = 130,["y"] = 40,["width"] = 5,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 3},
        ["J"] = {["x"] = 9,["y"] = 28,["width"] = 8,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["K"] = {["x"] = 120,["y"] = 28,["width"] = 11,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
        ["L"] = {["x"] = 20,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["M"] = {["x"] = 51,["y"] = 28,["width"] = 12,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 10},
        ["N"] = {["x"] = 30,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
        ["O"] = {["x"] = 130,["y"] = 0,["width"] = 11,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
        ["P"] = {["x"] = 40,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
        ["Q"] = {["x"] = 85,["y"] = 0,["width"] = 12,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 9},
        ["R"] = {["x"] = 131,["y"] = 28,["width"] = 11,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 9},
        ["S"] = {["x"] = 141,["y"] = 0,["width"] = 10,["height"] = 13,["originX"] = 1,["originY"] = 11,["advance"] = 8},
        ["T"] = {["x"] = 50,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["U"] = {["x"] = 23,["y"] = 15,["width"] = 10,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 9},
        ["V"] = {["x"] = 63,["y"] = 28,["width"] = 12,["height"] = 11,["originX"] = 2,["originY"] = 10,["advance"] = 8},
        ["W"] = {["x"] = 37,["y"] = 28,["width"] = 14,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 11},
        ["X"] = {["x"] = 60,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 8},
        ["Y"] = {["x"] = 75,["y"] = 28,["width"] = 12,["height"] = 11,["originX"] = 2,["originY"] = 10,["advance"] = 8},
        ["Z"] = {["x"] = 70,["y"] = 40,["width"] = 10,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["["] = {["x"] = 54,["y"] = 0,["width"] = 6,["height"] = 14,["originX"] = 1,["originY"] = 10,["advance"] = 4},
        ["\\"] = {["x"] = 16,["y"] = 15,["width"] = 7,["height"] = 13,["originX"] = 2,["originY"] = 11,["advance"] = 3},
        ["]"] = {["x"] = 60,["y"] = 0,["width"] = 6,["height"] = 14,["originX"] = 1,["originY"] = 10,["advance"] = 4},
        ["^"] = {["x"] = 0,["y"] = 61,["width"] = 9,["height"] = 8,["originX"] = 1,["originY"] = 11,["advance"] = 7},
        ["_"] = {["x"] = 63,["y"] = 61,["width"] = 10,["height"] = 4,["originX"] = 2,["originY"] = 0,["advance"] = 7},
        ["`"] = {["x"] = 58,["y"] = 61,["width"] = 5,["height"] = 5,["originX"] = 1,["originY"] = 11,["advance"] = 4},
        ["a"] = {["x"] = 0,["y"] = 51,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["b"] = {["x"] = 105,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["c"] = {["x"] = 9,["y"] = 51,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["d"] = {["x"] = 114,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["e"] = {["x"] = 18,["y"] = 51,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["f"] = {["x"] = 24,["y"] = 28,["width"] = 7,["height"] = 12,["originX"] = 1,["originY"] = 11,["advance"] = 4},
        ["g"] = {["x"] = 123,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["h"] = {["x"] = 107,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["i"] = {["x"] = 135,["y"] = 40,["width"] = 5,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 3},
        ["j"] = {["x"] = 66,["y"] = 0,["width"] = 6,["height"] = 14,["originX"] = 2,["originY"] = 10,["advance"] = 3},
        ["k"] = {["x"] = 116,["y"] = 40,["width"] = 9,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 7},
        ["l"] = {["x"] = 140,["y"] = 40,["width"] = 5,["height"] = 11,["originX"] = 1,["originY"] = 10,["advance"] = 3},
        ["m"] = {["x"] = 54,["y"] = 51,["width"] = 12,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 11},
        ["n"] = {["x"] = 105,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["o"] = {["x"] = 27,["y"] = 51,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["p"] = {["x"] = 132,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["q"] = {["x"] = 141,["y"] = 15,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["r"] = {["x"] = 140,["y"] = 51,["width"] = 7,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 5},
        ["s"] = {["x"] = 36,["y"] = 51,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["t"] = {["x"] = 31,["y"] = 28,["width"] = 6,["height"] = 12,["originX"] = 1,["originY"] = 10,["advance"] = 4},
        ["u"] = {["x"] = 45,["y"] = 51,["width"] = 9,["height"] = 10,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["v"] = {["x"] = 114,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["w"] = {["x"] = 66,["y"] = 51,["width"] = 12,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 9},
        ["x"] = {["x"] = 123,["y"] = 51,["width"] = 9,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["y"] = {["x"] = 0,["y"] = 28,["width"] = 9,["height"] = 12,["originX"] = 1,["originY"] = 8,["advance"] = 7},
        ["z"] = {["x"] = 132,["y"] = 51,["width"] = 8,["height"] = 9,["originX"] = 1,["originY"] = 8,["advance"] = 6},
        ["{"] = {["x"] = 14,["y"] = 0,["width"] = 7,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 5},
        ["|"] = {["x"] = 40,["y"] = 0,["width"] = 5,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 3},
        ["}"] = {["x"] = 21,["y"] = 0,["width"] = 7,["height"] = 15,["originX"] = 1,["originY"] = 11,["advance"] = 5},
        ["~"] = {["x"] = 43,["y"] = 61,["width"] = 9,["height"] = 5,["originX"] = 1,["originY"] = 7,["advance"] = 7}
      }
    }
}