import json
from PIL import Image
im = Image.open("textures/font-arial24-bold.png")

#Atlas description
#Obtain from: https://evanw.github.io/font-texture-generator/
data = json.loads("""
{
  "name": "Arial",
  "size": 24,
  "bold": true,
  "italic": false,
  "width": 284,
  "height": 102,
  "characters": {
    "0":{"x":64,"y":26,"width":15,"height":21,"originX":1,"originY":19,"advance":13},
    "1":{"x":105,"y":67,"width":11,"height":20,"originX":0,"originY":19,"advance":13},
    "2":{"x":267,"y":47,"width":15,"height":20,"originX":1,"originY":19,"advance":13},
    "3":{"x":79,"y":26,"width":15,"height":21,"originX":1,"originY":19,"advance":13},
    "4":{"x":0,"y":67,"width":15,"height":20,"originX":1,"originY":19,"advance":13},
    "5":{"x":94,"y":26,"width":15,"height":21,"originX":1,"originY":19,"advance":13},
    "6":{"x":109,"y":26,"width":15,"height":21,"originX":1,"originY":19,"advance":13},
    "7":{"x":15,"y":67,"width":15,"height":20,"originX":1,"originY":19,"advance":13},
    "8":{"x":124,"y":26,"width":15,"height":21,"originX":1,"originY":19,"advance":13},
    "9":{"x":139,"y":26,"width":15,"height":21,"originX":1,"originY":19,"advance":13},
    " ":{"x":260,"y":87,"width":3,"height":3,"originX":1,"originY":1,"advance":7},
    "!":{"x":148,"y":67,"width":6,"height":20,"originX":-1,"originY":19,"advance":8},
    "\\"":{"x":184,"y":87,"width":12,"height":9,"originX":0,"originY":19,"advance":11},
    "#":{"x":0,"y":26,"width":16,"height":21,"originX":1,"originY":19,"advance":13},
    "$":{"x":100,"y":0,"width":15,"height":24,"originX":1,"originY":20,"advance":13},
    "%":{"x":136,"y":0,"width":23,"height":21,"originX":1,"originY":19,"advance":21},
    "&":{"x":159,"y":0,"width":20,"height":21,"originX":1,"originY":19,"advance":17},
    "'":{"x":196,"y":87,"width":7,"height":9,"originX":1,"originY":19,"advance":6},
    "(":{"x":58,"y":0,"width":9,"height":26,"originX":0,"originY":19,"advance":8},
    ")":{"x":67,"y":0,"width":9,"height":26,"originX":1,"originY":19,"advance":8},
    "*":{"x":166,"y":87,"width":11,"height":11,"originX":1,"originY":19,"advance":9},
    "+":{"x":42,"y":87,"width":16,"height":15,"originX":1,"originY":16,"advance":14},
    ",":{"x":177,"y":87,"width":7,"height":10,"originX":0,"originY":5,"advance":7},
    "-":{"x":219,"y":87,"width":9,"height":7,"originX":0,"originY":10,"advance":8},
    ".":{"x":236,"y":87,"width":7,"height":6,"originX":0,"originY":5,"advance":7},
    "/":{"x":183,"y":26,"width":10,"height":21,"originX":2,"originY":19,"advance":7},
    ":":{"x":130,"y":87,"width":6,"height":15,"originX":-1,"originY":14,"advance":8},
    ";":{"x":154,"y":67,"width":7,"height":19,"originX":0,"originY":14,"advance":8},
    "<":{"x":161,"y":67,"width":16,"height":16,"originX":1,"originY":17,"advance":14},
    "=":{"x":150,"y":87,"width":16,"height":11,"originX":1,"originY":14,"advance":14},
    ">":{"x":177,"y":67,"width":16,"height":16,"originX":1,"originY":17,"advance":14},
    "?":{"x":30,"y":67,"width":15,"height":20,"originX":0,"originY":19,"advance":15},
    "@":{"x":0,"y":0,"width":26,"height":26,"originX":1,"originY":19,"advance":23},
    "A":{"x":238,"y":26,"width":21,"height":20,"originX":2,"originY":19,"advance":17},
    "B":{"x":98,"y":47,"width":18,"height":20,"originX":0,"originY":19,"advance":17},
    "C":{"x":218,"y":0,"width":18,"height":21,"originX":0,"originY":19,"advance":17},
    "D":{"x":116,"y":47,"width":18,"height":20,"originX":0,"originY":19,"advance":17},
    "E":{"x":219,"y":47,"width":16,"height":20,"originX":0,"originY":19,"advance":16},
    "F":{"x":45,"y":67,"width":15,"height":20,"originX":0,"originY":19,"advance":15},
    "G":{"x":199,"y":0,"width":19,"height":21,"originX":0,"originY":19,"advance":19},
    "H":{"x":134,"y":47,"width":17,"height":20,"originX":0,"originY":19,"advance":17},
    "I":{"x":127,"y":67,"width":7,"height":20,"originX":0,"originY":19,"advance":7},
    "J":{"x":169,"y":26,"width":14,"height":21,"originX":1,"originY":19,"advance":13},
    "K":{"x":60,"y":47,"width":19,"height":20,"originX":0,"originY":19,"advance":17},
    "L":{"x":235,"y":47,"width":16,"height":20,"originX":0,"originY":19,"advance":15},
    "M":{"x":259,"y":26,"width":20,"height":20,"originX":0,"originY":19,"advance":20},
    "N":{"x":151,"y":47,"width":17,"height":20,"originX":0,"originY":19,"advance":17},
    "O":{"x":179,"y":0,"width":20,"height":21,"originX":1,"originY":19,"advance":19},
    "P":{"x":168,"y":47,"width":17,"height":20,"originX":0,"originY":19,"advance":16},
    "Q":{"x":115,"y":0,"width":21,"height":22,"originX":1,"originY":19,"advance":19},
    "R":{"x":79,"y":47,"width":19,"height":20,"originX":0,"originY":19,"advance":17},
    "S":{"x":236,"y":0,"width":17,"height":21,"originX":1,"originY":19,"advance":16},
    "T":{"x":185,"y":47,"width":17,"height":20,"originX":1,"originY":19,"advance":15},
    "U":{"x":253,"y":0,"width":17,"height":21,"originX":0,"originY":19,"advance":17},
    "V":{"x":0,"y":47,"width":20,"height":20,"originX":2,"originY":19,"advance":16},
    "W":{"x":213,"y":26,"width":25,"height":20,"originX":1,"originY":19,"advance":23},
    "X":{"x":20,"y":47,"width":20,"height":20,"originX":2,"originY":19,"advance":16},
    "Y":{"x":40,"y":47,"width":20,"height":20,"originX":2,"originY":19,"advance":16},
    "Z":{"x":202,"y":47,"width":17,"height":20,"originX":1,"originY":19,"advance":15},
    "[":{"x":82,"y":0,"width":9,"height":25,"originX":0,"originY":19,"advance":8},
    "\\\\":{"x":193,"y":26,"width":10,"height":21,"originX":2,"originY":19,"advance":7},
    "]":{"x":91,"y":0,"width":9,"height":25,"originX":1,"originY":19,"advance":8},
    "^":{"x":136,"y":87,"width":14,"height":12,"originX":0,"originY":19,"advance":14},
    "_":{"x":243,"y":87,"width":17,"height":5,"originX":2,"originY":-1,"advance":13},
    "`":{"x":228,"y":87,"width":8,"height":7,"originX":1,"originY":19,"advance":8},
    "a":{"x":209,"y":67,"width":15,"height":16,"originX":1,"originY":14,"advance":13},
    "b":{"x":154,"y":26,"width":15,"height":21,"originX":0,"originY":19,"advance":15},
    "c":{"x":224,"y":67,"width":15,"height":16,"originX":1,"originY":14,"advance":13},
    "d":{"x":16,"y":26,"width":16,"height":21,"originX":1,"originY":19,"advance":15},
    "e":{"x":239,"y":67,"width":15,"height":16,"originX":1,"originY":14,"advance":13},
    "f":{"x":116,"y":67,"width":11,"height":20,"originX":1,"originY":19,"advance":8},
    "g":{"x":32,"y":26,"width":16,"height":21,"originX":1,"originY":14,"advance":15},
    "h":{"x":60,"y":67,"width":15,"height":20,"originX":0,"originY":19,"advance":15},
    "i":{"x":134,"y":67,"width":7,"height":20,"originX":0,"originY":19,"advance":7},
    "j":{"x":48,"y":0,"width":10,"height":26,"originX":3,"originY":19,"advance":7},
    "k":{"x":75,"y":67,"width":15,"height":20,"originX":0,"originY":19,"advance":13},
    "l":{"x":141,"y":67,"width":7,"height":20,"originX":0,"originY":19,"advance":7},
    "m":{"x":0,"y":87,"width":21,"height":15,"originX":0,"originY":14,"advance":21},
    "n":{"x":90,"y":87,"width":15,"height":15,"originX":0,"originY":14,"advance":15},
    "o":{"x":193,"y":67,"width":16,"height":16,"originX":1,"originY":14,"advance":15},
    "p":{"x":90,"y":67,"width":15,"height":20,"originX":0,"originY":14,"advance":15},
    "q":{"x":251,"y":47,"width":16,"height":20,"originX":1,"originY":14,"advance":15},
    "r":{"x":119,"y":87,"width":11,"height":15,"originX":0,"originY":14,"advance":9},
    "s":{"x":254,"y":67,"width":15,"height":16,"originX":1,"originY":14,"advance":13},
    "t":{"x":203,"y":26,"width":10,"height":21,"originX":1,"originY":19,"advance":8},
    "u":{"x":269,"y":67,"width":15,"height":16,"originX":0,"originY":14,"advance":15},
    "v":{"x":58,"y":87,"width":16,"height":15,"originX":1,"originY":14,"advance":13},
    "w":{"x":21,"y":87,"width":21,"height":15,"originX":1,"originY":14,"advance":19},
    "x":{"x":74,"y":87,"width":16,"height":15,"originX":1,"originY":14,"advance":13},
    "y":{"x":48,"y":26,"width":16,"height":21,"originX":1,"originY":14,"advance":13},
    "z":{"x":105,"y":87,"width":14,"height":15,"originX":1,"originY":14,"advance":12},
    "{":{"x":26,"y":0,"width":11,"height":26,"originX":1,"originY":19,"advance":9},
    "|":{"x":76,"y":0,"width":6,"height":26,"originX":0,"originY":19,"advance":7},
    "}":{"x":37,"y":0,"width":11,"height":26,"originX":1,"originY":19,"advance":9},
    "~":{"x":203,"y":87,"width":16,"height":8,"originX":1,"originY":13,"advance":14}
  }
}
""")

for k in data["characters"]:
    x = data['characters'][k]
    char = im.crop((x['x'], x['y'], x['x'] + x['width'], x['y'] + x['height']))
    char.save(open(f'textures/arial_char_{ord(k)}.png', 'wb'))
    
